from aip import AipImageClassify
import os
from PIL import Image,ImageDraw,ImageFont
from openpyxl import Workbook
def get_file_content(filePath):
    with open(filePath, 'rb') as fp:
        return fp.read()
""" 你的 APPID AK SK """
APP_ID = '********'
API_KEY = '********'
SECRET_KEY = '********'
client = AipImageClassify(APP_ID, API_KEY, SECRET_KEY)
wb=Workbook()
sheet=wb.active
sheet.append(['图片文件名','车型','年份','颜色'])
car=os.listdir('images_car')
for oi in car:
    image = get_file_content('./images_car/'+oi)
    """ 如果有可选参数 """
    options = {}
    options["top_num"] = 10
    options["baike_num"] ="name,year"
    """ 带参数调用车辆识别 """
    result=client.carDetect(image, options)
    #print(result)
    name=result['result'][0]['name']
    year=result['result'][0]['year']
    color=result['color_result']
    print('车辆图片文件名：' + oi)
    print('车型：',name )
    print('年份：', year)
    print('颜色：', color)
    print('')
    img=Image.open('./images_car/'+oi)  #打开图片以及更改图片
    draw=ImageDraw.Draw(img)
    ifont=ImageFont.truetype("C:\Windows\Fonts\Fonts/STXINGKA",15)
    draw.rectangle((0,0,150,80),fill='blue')
    draw.text([5,10],"车型："+name,"white",font=ifont)
    draw.text([5, 30], "年份：" +year, "white", font=ifont,)
    draw.text([5,50],"颜色："+color,"white", font=ifont)
    img.show()
    sheet.append([oi,name,year,color])
wb.save('car.xlsx')
